#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_TransfusionReactionReport : BaseTest 
	{
		#region Variables

		private DateTime _startDate;
		private DateTime _endDate;

		#endregion

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();
			//
			// Set start date to a bit ago
			this._startDate = System.DateTime.Now.AddYears(-5);
			this._endDate = System.DateTime.Now;
		}

		[Test]
		public void GetSummaryDataForReport_Pass()
		{
			DataSet reportData = DAL.TransfusionReactionReport.GetSummaryDataForReport(this._startDate, this._endDate);
			DataTable dtTest = reportData.Tables[0];

			Assert.AreEqual(1, reportData.Tables.Count, "Tables.Count");
			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.DivisionCode), TABLES.PatientTransfusionReaction.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.DivisionName), TABLES.VamcDivision.DivisionName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.TransfusionReactionTypeCode), TABLES.TransfusionReactionType.TransfusionReactionTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.TransfusionReactionTypeText), TABLES.TransfusionReactionType.TransfusionReactionTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.TransfusionEndDateTime), TABLES.PatientTransfusion.TransfusionEndDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.LastUpdateDate), TABLES.PatientTransfusionReaction.LastUpdateDate);
		}
		
		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetSummaryDataForReport_Fail()
		{
			DAL.TransfusionReactionReport.GetSummaryDataForReport(DateTime.MinValue, DateTime.MinValue);
		}

		[Test]
		public void GetSummaryDataForReportAllDivisions_Pass()
		{
			DataSet reportData = DAL.TransfusionReactionReport.GetSummaryDataForReportAllDivisions(this._startDate, this._endDate);
			DataTable dtTest = reportData.Tables[0];

			Assert.AreEqual(1, reportData.Tables.Count, "Tables.Count");
			Assert.AreEqual(8, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.DivisionCode), TABLES.PatientTransfusionReaction.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.DivisionName), TABLES.VamcDivision.DivisionName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.TransfusionReactionTypeCode), TABLES.TransfusionReactionType.TransfusionReactionTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.TransfusionReactionTypeText), TABLES.TransfusionReactionType.TransfusionReactionTypeText);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), TABLES.BloodUnit.EyeReadableUnitId);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.TransfusionEndDateTime), TABLES.PatientTransfusion.TransfusionEndDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.LastUpdateDate), TABLES.PatientTransfusionReaction.LastUpdateDate);
		}
		
		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetSummaryDataForReportAllDivisions_Fail()
		{
			DAL.TransfusionReactionReport.GetSummaryDataForReportAllDivisions(DateTime.MinValue, DateTime.MinValue);
		}

		[Test]
		public void GetDetailedDataForReport_Pass()
		{
			DataSet reportData = DAL.TransfusionReactionReport.GetDetailedDataForReport(this._startDate, this._endDate);
			
			Assert.AreEqual(2, reportData.Tables.Count, "Tables.Count");

			DataTable dtTest = reportData.Tables[0];
			Assert.AreEqual(22, dtTest.Columns.Count, "[0] -Columns.Count");

			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.TableName), "[0] -" + ARTIFICIAL.TableName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid), "[0] -" + TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.DivisionCode), "[0] -" + TABLES.PatientTransfusionReaction.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PartialSaveId), "[0] -" + TABLES.PatientTransfusionReaction.PartialSaveId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.DivisionName), "[0] -" + TABLES.VamcDivision.DivisionName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.TransfusionReactionTypeCode), "[0] -" + TABLES.TransfusionReactionType.TransfusionReactionTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.TransfusionReactionTypeText), "[0] -" + TABLES.TransfusionReactionType.TransfusionReactionTypeText);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.Patient.PatientLastName), "[0] -" + TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), "[0] -" + TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), "[0] -" + TABLES.Patient.PatientMiddleName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), "[0] -" + TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), "[0] -" + TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), "[0] -" + TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.EntryDateTime), "[0] -" + TABLES.PatientTransfusionReaction.EntryDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.InvestigatedDateTime), "[0] -" + TABLES.PatientTransfusionReaction.InvestigatedDateTime);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.TransfusionEndDateTime), "[0] -" + TABLES.PatientTransfusion.TransfusionEndDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TreatingSpecialty.TreatingSpecialtyName), "[0] -" + TABLES.TreatingSpecialty.TreatingSpecialtyName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.MedicalDirectorName), "[0] -" + TABLES.PatientTransfusionReaction.MedicalDirectorName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderLastName), "[0] -" + TABLES.PatientOrder.OrderingProviderLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderFirstName), "[0] -" + TABLES.PatientOrder.OrderingProviderFirstName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderMiddleInitial), "[0] -" + TABLES.PatientOrder.OrderingProviderMiddleInitial);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.LastUpdateDate), "[0] -" + TABLES.PatientTransfusionReaction.LastUpdateDate);


			dtTest = reportData.Tables[1];
			Assert.AreEqual(3, dtTest.Columns.Count, "[1] -Columns.Count");
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.TableName), "[0] -" + ARTIFICIAL.TableName);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid), "[1] -" + TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.PatientTransfusionComment.PatientTransfusionCommentText), "[1] -" + TABLES.PatientTransfusionComment.PatientTransfusionCommentText);

		}
		
		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetDetailedDataForReport_Fail()
		{
			DAL.TransfusionReactionReport.GetDetailedDataForReport(DateTime.MinValue, DateTime.MinValue);
		}

		[Test]
		public void GetDetailedDataForReportAllDivisions_Pass()
		{
			DataSet reportData = DAL.TransfusionReactionReport.GetDetailedDataForReportAllDivisions(this._startDate, this._endDate);
			Assert.AreEqual(2, reportData.Tables.Count, "Tables.Count");

			DataTable dtTest = reportData.Tables[0];
			Assert.AreEqual(22, dtTest.Columns.Count, "[0] -Columns.Count");

			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.TableName), "[0] -" + ARTIFICIAL.TableName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid), "[0] -" + TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.DivisionCode), "[0] -" + TABLES.PatientTransfusionReaction.DivisionCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PartialSaveId), "[0] -" + TABLES.PatientTransfusionReaction.PartialSaveId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VamcDivision.DivisionName), "[0] -" + TABLES.VamcDivision.DivisionName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.TransfusionReactionTypeCode), "[0] -" + TABLES.TransfusionReactionType.TransfusionReactionTypeCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TransfusionReactionType.TransfusionReactionTypeText), "[0] -" + TABLES.TransfusionReactionType.TransfusionReactionTypeText);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.Patient.PatientLastName), "[0] -" + TABLES.Patient.PatientLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientFirstName), "[0] -" + TABLES.Patient.PatientFirstName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.PatientMiddleName), "[0] -" + TABLES.Patient.PatientMiddleName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.Patient.DisplayVistaPatientId), "[0] -" + TABLES.Patient.DisplayVistaPatientId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.BloodUnit.EyeReadableUnitId), "[0] -" + TABLES.BloodUnit.EyeReadableUnitId);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.BloodProduct.ProductName), "[0] -" + TABLES.BloodProduct.ProductName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.EntryDateTime), "[0] -" + TABLES.PatientTransfusionReaction.EntryDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.InvestigatedDateTime), "[0] -" + TABLES.PatientTransfusionReaction.InvestigatedDateTime);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusion.TransfusionEndDateTime), "[0] -" + TABLES.PatientTransfusion.TransfusionEndDateTime);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.TreatingSpecialty.TreatingSpecialtyName), "[0] -" + TABLES.TreatingSpecialty.TreatingSpecialtyName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.MedicalDirectorName), "[0] -" + TABLES.PatientTransfusionReaction.MedicalDirectorName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderLastName), "[0] -" + TABLES.PatientOrder.OrderingProviderLastName);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderFirstName), "[0] -" + TABLES.PatientOrder.OrderingProviderFirstName);

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientOrder.OrderingProviderMiddleInitial), "[0] -" + TABLES.PatientOrder.OrderingProviderMiddleInitial);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.LastUpdateDate), "[0] -" + TABLES.PatientTransfusionReaction.LastUpdateDate);


			dtTest = reportData.Tables[1];
			Assert.AreEqual(3, dtTest.Columns.Count, "[1] -Columns.Count");
			Assert.AreEqual(true , dtTest.Columns.Contains(ARTIFICIAL.TableName), "[0] -" + ARTIFICIAL.TableName);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid), "[1] -" + TABLES.PatientTransfusionReaction.PatientTransfusionReactionGuid);
			Assert.AreEqual(true , dtTest.Columns.Contains(TABLES.PatientTransfusionComment.PatientTransfusionCommentText), "[1] -" + TABLES.PatientTransfusionComment.PatientTransfusionCommentText);

		}

		[Test]
		[ExpectedException(typeof(ArgumentException))]
		public void GetDetailedDataForReportAllDivisions_Fail()
		{
			DAL.TransfusionReactionReport.GetDetailedDataForReportAllDivisions(DateTime.MinValue, DateTime.MinValue);
		}
	}
}
#endif
